#include <amxmodx>
#include <amxmisc>

#define VERSION	"0.1"

new hsfEnable, hsfMessage, hsfAdvertise;
new DisplayMenu;

public plugin_init( )
{
	register_plugin( "Hand Switch Fix", VERSION, "3Di" ); 
	
	register_clcmd( "say /hand", "CmdHandSwitch" );
	register_clcmd( "say_team /hand", "CmdHandSwitch" );
	
	hsfEnable = register_cvar( "amx_hsf_enable", "1" );
	hsfMessage = register_cvar( "amx_hsf_message", "0" );
	hsfAdvertise = register_cvar( "amx_hsf_advertise", "0" );
	
	DisplayMenu = menu_create( "\dHand Switch Fix^n\rSelect your playing hand:", "HandleMenu" );
}

public CmdHandSwitch( id )
{
	if ( !get_pcvar_num( hsfEnable ) )
		return PLUGIN_HANDLED;
	
	if ( !is_user_connected( id ) )
		return PLUGIN_HANDLED;
	
	menu_additem( DisplayMenu, "\wRight Hand", "1", 0 );
	menu_additem( DisplayMenu, "\wLeft Hand", "2", 0 );
	
	menu_setprop( DisplayMenu, MPROP_EXIT, MEXIT_ALL );
	
	menu_display( id, DisplayMenu, 0 );
	
	return PLUGIN_HANDLED;
}

public HandleMenu( id, DisplayMenu, Item )
{
	if ( Item == MENU_EXIT )
	{
		menu_destroy( DisplayMenu );
		
		return PLUGIN_HANDLED;
	}
	
	new ReadData[ 6 ], ClientName[ 64 ];
	
	new MenuAccess, CallBack;
	menu_item_getinfo( DisplayMenu, Item, MenuAccess, ReadData, 5, ClientName, 63, CallBack );
	
	new HandleKey = str_to_num( ReadData );
	
	switch( HandleKey )
	{
		case 1:
		{
			client_cmd( id, "cl_righthand 1" );
			
			if ( !get_pcvar_num( hsfMessage ) )
				return PLUGIN_HANDLED;
			
			client_print( id, print_chat, "[AMXX] Setting your playing hand to: RIGHT HAND." );
		}
		
		case 2:
		{
			client_cmd( id, "cl_righthand 0" );
			
			if ( !get_pcvar_num( hsfMessage ) )
				return PLUGIN_HANDLED;
			
			client_print( id, print_chat, "[AMXX] Setting your playing hand to: LEFT HAND." );
		}
	}
	
	menu_destroy( DisplayMenu );
	return PLUGIN_HANDLED;
}

public client_putinserver( id )
{
	if ( !get_pcvar_num( hsfEnable ) )
		return PLUGIN_HANDLED;
	
	if ( !get_pcvar_num( hsfAdvertise ) )
		return PLUGIN_HANDLED;
	
	set_task( random_float( 15.0, 30.0 ), "AdvertiseHands", id );
	
	return PLUGIN_HANDLED;
}

public AdvertiseHands( id )
{
	client_print( id, print_chat, "[AMXX] Type /hand in chat to easily switch your playing hand." );
	
	return;
}
	